<?php

namespace App\Models\HR;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class AppointmentGrossPay extends Model 
{

    protected $table = 'appointments_gross_pay';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function appointment()
    {
        return $this->belongsTo('App\Models\HR\Appointment', 'appointment_id');
    }

    public function financial_period()
    {
        return $this->belongsTo('App\Models\Finance\FinancialPeriod', 'financial_period_id');
    }

}